#!/bin/sh
# Installs Debian Kernel to NAND
set -e
#/usr/sbin/debian-install-kernel-modules.sh -b mx6cb -t res
MEDIA=/opt/images/Debian
KERNEL_MODULES=modules

install_kernel_modules()
{
        if [ ! -d $MEDIA/$KERNEL_MODULES ] ; then
                echo "ERROR: \"$MEDIA/$KERNEL_MODULES\" does not exist"
                exit 1
        fi
        echo
        echo "Installing kernel modules"
        cp -pr $MEDIA/$KERNEL_MODULES/*  /lib/modules
}

usage()
{
        echo
        echo "This script installs Debian Kernel Modules on LCRiQ VAR-SOM-MX6"
        echo
        echo " Usage: $0 "
        echo
        echo
}

finish()
{
        echo
        echo "Debian Kernel installed modules successfully"
        exit 0
}


echo "*** LC VAR-MX6 Debian NAND RECOVERY  ***"
echo

### Force options
BOARD="mx6cb"
TOUCHSCREEN="res"
KERNEL_DTB=imx6dl-var-som-solo-res.dtb

STR="LCRiQ"
printf "Carrier board: "
echo $STR

STR="Resistive"
printf "Touchscreen model: "
echo $STR

printf "Installing Kernel Modules "
echo $KERNEL_MODULES

install_kernel_modules

finish
