#!/bin/sh
# Installs Debian Kernel to NAND
set -e
#/usr/sbin/debian-install.sh -b mx6cb -t res
MEDIA=/opt/images/Debian
KERNEL_IMAGE=uImage
KERNEL_DTB=""

install_kernel()
{
        if [ ! -f $MEDIA/$KERNEL_IMAGE ] ; then
                echo "ERROR: \"$MEDIA/$KERNEL_IMAGE\" does not exist"
                exit 1
        fi
        echo
        echo "Installing kernel"
        flash_erase /dev/mtd2 0 0 2> /dev/null
        nandwrite -p /dev/mtd2 $MEDIA/$KERNEL_IMAGE > /dev/null
        nandwrite -p /dev/mtd1 -s 0x1e0000 $MEDIA/$KERNEL_DTB > /dev/null
}

usage()
{
        echo
        echo "This script installs Debian Kernel on LCRiQ VAR-SOM-MX6"
        echo
        echo " Usage: $0 "
        echo
        echo
}

finish()
{
        echo
        echo "Debian Kernel installed successfully"
        exit 0
}


echo "*** LC VAR-MX6 Debian NAND RECOVERY  ***"
echo

### Force options
BOARD="mx6cb"
TOUCHSCREEN="res"
KERNEL_DTB=imx6dl-var-som-solo-res.dtb

STR="LCRiQ"
printf "Carrier board: "
echo $STR

STR="Resistive"
printf "Touchscreen model: "
echo $STR

printf "Installing Device Tree file: "
echo $KERNEL_DTB

install_kernel

finish
